VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CToolbar32"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
 
Public Enum ToolBarSyle
 CheckGroup
 StyleList
 Normal
End Enum

'Window Styles
Private Const WS_CHILD = &H40000000
Private Const WS_VISIBLE = &H10000000
Private Const WS_CLIPCHILDREN = &H2000000
Private Const WS_CLIPSIBLINGS = &H4000000
Private Const WS_BORDER = &H800000

Private Declare Function CreateToolbarEx Lib "COMCTL32" (ByVal hWnd As Long, ByVal ws As Long, ByVal wID As Long, ByVal nBitmaps As Long, ByVal hBMInst As Long, ByVal wBMID As Long, ByRef lpButtons As TBBUTTON, ByVal iNumButtons As Long, ByVal dxButton As Long, ByVal dyButton As Long, ByVal dxBitmap As Long, ByVal dyBitmap As Long, ByVal uStructSize As Long) As Long
Private Declare Function InitCommonControlsEx Lib "Comctl32.dll" (iccex As tagInitCommonControlsEx) As Boolean
Private Declare Function UpdateWindow Lib "user32" (ByVal hWnd As Long) As Long
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function ShowWindow Lib "user32" (ByVal hWnd As Long, ByVal nCmdShow As Long) As Long
Private Declare Function SendStringMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As String) As Long
Private Declare Function MoveWindow Lib "user32" (ByVal hWnd As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long
Private Declare Function SendMessageByval Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function SetParent Lib "user32" (ByVal hWndChild As Long, ByVal hWndNewParent As Long) As Long
Private Declare Function DestroyWindow Lib "user32" (ByVal hWnd As Long) As Long

#If UNICODE Then
Private Declare Function CreateWindowEX Lib "user32" Alias "CreateWindowExW" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, lpParam As Any) As Long
Private Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcW" (ByVal lpPrevWndFunc As Long, ByVal hWnd As Long, ByVal msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongW" (ByVal hWnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Any) As Long
Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongW" (ByVal hWnd As Long, ByVal nIndex As Long) As Long
#Else
Private Declare Function CreateWindowEX Lib "user32" Alias "CreateWindowExA" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, lpParam As Any) As Long
Private Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hWnd As Long, ByVal msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hWnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Any) As Long
Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" (ByVal hWnd As Long, ByVal nIndex As Long) As Long
#End If

Private Toolbar As Long
Private ToolBarWnd As Long
Private ButtonWidth As Integer
Private ButtonHeight As Integer
Private ToolBarMainParentForMessages As Object
Private CaptionLen As Integer
Private Num As Integer

Private Type tagInitCommonControlsEx
lngSize As Long
lngICC As Long
End Type

Dim Ret As Long
Dim Butns As Long

Private Type ButtonInfo
idNum As Integer
BitMapNum As Integer
PosNum As Integer
TipsText As String
TextIndexNum As Integer
ButnText As String
Large As Integer
xWidth As Integer
xHeight As Integer
End Type

Private BInfo() As ButtonInfo

Private Type BCommand
Command As Integer
TipNum As Integer
End Type

Private Buttons32 As Integer
Private toolbarwindow As Long

Const ICC_BAR_CLASSES = &H4
Private Const SW_SHOW = 5

Const HWND_TOPMOST = -1
Const SW_HIDE = 0
Const SW_SHOWNORMAL = 1
 
Private Type TBADDBITMAP
hInst As Long
nID As Long
End Type
  
Private Type BUTTONDATA
iBitmap As Integer
idCommand As Integer
fsState As Long
fsStyle As Long
lpszButtonText As String
lpszTooltip As String
End Type
 
Private Const TOOLBARCLASSNAME = "ToolbarWindow32"
Private Const WM_PAINT = &HF
Private Const TBSTYLE_BUTTON = &H0
Private Const TBSTYLE_SEP = &H1
Private Const TBSTYLE_CHECK = &H2
Private Const TBSTYLE_GROUP = &H4
Private Const TBSTYLE_CHECKGROUP = (TBSTYLE_GROUP Or TBSTYLE_CHECK)
Private Const TBSTYLE_DROPDOWN = &H8
Private Const TBSTATE_ENABLED = &H4
Private Const TBSTYLE_TOOLTIPS = &H100
Private Const TBSTYLE_WRAPABLE = &H200
Private Const TBSTYLE_ALTDRAG = &H400
Private Const TBSTYLE_FLAT = &H800
Private Const TBSTYLE_LIST = &H1000
Private Const WM_USER = &H400
Private Const GWL_HWNDPARENT = (-8)
Private Const GWL_STYLE = (-16)
Private Const TB_ADDBUTTONS = (WM_USER + 20)
Private Const TB_INSERTBUTTON = (WM_USER + 21)
Private Const TBSTATE_CHECKED = &H1
Private Const TBSTATE_PRESSED = &H2
Private Const TB_BUTTONSTRUCTSIZE = (WM_USER + 30)
Private Const TB_SETMAXTEXTROWS = (WM_USER + 60)
Private Const TB_SETBITMAPSIZE = (WM_USER + 32)
Private Const TBSTATE_WRAP = &H20
Private Const TB_SETBUTTONWIDTH = (WM_USER + 59)
Private Const TB_SETBUTTONSIZE = (WM_USER + 31)
Private Const TBSTATE_ELLIPSES = &H40
Private Const TB_AUTOSIZE = (WM_USER + 33)
Private Const TBSTATE_INDETERMINATE = &H10
Private Const TB_DELETEBUTTON = (WM_USER + 22)
Private Const TB_ENABLEBUTTON = (WM_USER + 1)
Private Const TB_CHECKBUTTON = (WM_USER + 2)
Private Const TB_PRESSBUTTON = (WM_USER + 3)
Private Const TB_HIDEBUTTON = (WM_USER + 4)
Private Const TB_INDETERMINATE = (WM_USER + 5)
Private Const TB_GETBUTTONTEXTA = (WM_USER + 45)
Private Const TBN_FIRST = &H700
Private Const TBN_LAST = &H720
Private Const TBN_DROPDOWN = (TBN_FIRST - 10)
Private Const TBN_CLOSEUP = (TBN_FIRST - 11)
Private Const TB_ADDSTRING = (WM_USER + 28)
Private Const TB_SETSTATE = (WM_USER + 17)
Private Const TB_GETSTATE = (WM_USER + 18)
Private Const TB_ADDBITMAP = (WM_USER + 19)
Private Const TB_SETPARENT = (WM_USER + 37)
 
'//Common Control Constants
Private Const CCS_TOP = &H1
Private Const CCS_NOMOVEY = &H2
Private Const CCS_BOTTOM = &H3
Private Const CCS_NORESIZE = &H4
Private Const CCS_NOPARENTALIGN = &H8
Private Const CCS_NODIVIDER = &H40
Private Const CCS_VERT = &H80
Private Const CCS_LEFT = (CCS_VERT Or CCS_TOP)
Private Const CCS_RIGHT = (CCS_VERT Or CCS_BOTTOM)


 Private Type TBBUTTON
iBitmap As Long
idCommand As Long
fsState As Byte
fsStyle As Byte
bReserved1 As Byte
bReserved2 As Byte
dwData As Long
iString As Long
End Type
 
Dim mfrmParent As Object
Dim ImgSource As Object

 
 
Public Sub AddSeparator(id As Integer, PosNumber As Integer)
Dim Button As TBBUTTON
 
Button.idCommand = id
Button.fsState = TBSTATE_ENABLED
Button.fsStyle = TBSTYLE_SEP Or TBSTYLE_GROUP
Button.dwData = 0
Button.iString = 1

Ret = SendMessage(ToolBarWnd, TB_ADDBUTTONS, 1, Button)
End Sub

 
Public Function GetToolbarHwnd()
GetToolbarHwnd = ToolBarWnd
End Function

Private Sub Class_Initialize()
Dim iccex As tagInitCommonControlsEx
With iccex
.lngSize = LenB(iccex)
.lngICC = ICC_BAR_CLASSES
End With

'We need to make this call to make sure the common controls are loaded
Call InitCommonControlsEx(iccex)

ToolBarWnd = 0
End Sub
Public Property Get Parent() As Object
    Set Parent = mfrmParent
End Property

Public Property Set Parent(frm As Object)
    Set mfrmParent = frm
End Property

Public Property Set MainParent(frm As Object)
Set ToolBarMainParentForMessages = frm
End Property
Public Property Set ImageForToolbar(frm As Object)
Set ImgSource = frm
End Property
Public Sub DestroyToolBar()
On Error Resume Next
'We need to clean up our windows
If ToolBarWnd <> 0 Then
   Call DestroyWindow(ToolBarWnd)
   Call DestroyWindow(Toolbar)
End If
End Sub

Public Sub CreateToolbar(Optional ButtonSize As Integer = 16, Optional StyleList As Boolean, Optional WithText As Boolean, Optional Wrappable As Boolean, Optional PicSize As Integer)
On Error Resume Next
Dim tbab As TBADDBITMAP
Dim Button As TBBUTTON
 
Dim lParam As Long
Dim ListButtons As Boolean


Dim Wrap As Long
Dim List As Long

If StyleList = True Then List = TBSTYLE_LIST
If Wrappable = True Then Wrap = TBSTYLE_WRAPABLE

ToolBarWnd = CreateWindowEX(0, "ToolbarWindow32", "", _
WS_CHILD Or WS_VISIBLE Or TB_AUTOSIZE Or Wrap Or List Or _
CCS_NODIVIDER Or TBSTYLE_TOOLTIPS Or WS_CLIPCHILDREN Or _
CCS_NOPARENTALIGN Or CCS_NORESIZE Or TBSTYLE_FLAT, _
0, 0, 0, 0, Parent.hWnd, 0&, App.hInstance, 0&)
  
Call SendMessage(ToolBarWnd, TB_SETPARENT, ToolBarMainParentForMessages.hWnd, 0)
 
If ButtonSize = 16 Then
Call MoveWindow(ToolBarWnd, 0, 0, 1500, 22, True)
ElseIf ButtonSize = 32 And WithText = False Then
Call MoveWindow(ToolBarWnd, 0, 0, 850, 38, True)
ElseIf ButtonSize = 32 And WithText = True Then
Call MoveWindow(ToolBarWnd, 0, 0, 850, 50, True)
End If
 
Ret = SendMessageByval(ToolBarWnd, TB_BUTTONSTRUCTSIZE, LenB(Button), 0)
 
lParam = ButtonSize + (ButtonSize * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBITMAPSIZE, 0, lParam)
 
tbab.hInst = 0
tbab.nID = ImgSource.Picture.Handle

' Add the bitmap containing button images to the toolbar.
Ret = SendMessage(ToolBarWnd, TB_ADDBITMAP, 54, tbab)
 
 
'tell the toolbar the size of the buttons
If ButtonSize = 16 And WithText = False Then
lParam = ButtonSize + (ButtonSize * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
ElseIf ButtonSize = 16 And WithText = True Then 'Else
lParam = ButtonSize + (ButtonSize * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
ElseIf ButtonSize = 32 And WithText = False Then 'Else
lParam = ButtonSize + (ButtonSize * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
ElseIf ButtonSize = 32 And WithText = True Then
lParam = 50 + (50 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
End If
 

End Sub

 
Public Sub ImageSource(Scr As Object)
    Set ImgSource = Scr
End Sub
Public Sub AddButton(id As Integer, zTip As String, BitPic As Integer, Optional PosNumber As Integer = -1, Optional xLarge As Integer = 0, Optional ButtonText As String, Optional AdditionStyle As ToolBarSyle = Normal)
 

Dim Button As TBBUTTON
 
On Error Resume Next
Dim sBuffer As String
Dim NewStyle As Long

'Check to see what style
If AdditionStyle = CheckGroup Then
NewStyle = TBSTYLE_CHECKGROUP
ElseIf AdditionStyle = StyleList Then
NewStyle = TBSTYLE_LIST
Else
NewStyle = 0
End If


Dim lParam As Long
If id > UBound(BInfo) Then
ReDim Preserve BInfo(id)
End If
If PosNumber = -1 Then PosNumber = id

  BInfo(id).idNum = id
  BInfo(id).BitMapNum = BitPic
  BInfo(id).TipsText = zTip
  BInfo(id).PosNum = PosNumber
  BInfo(id).Large = xLarge
  
If Len(ButtonText) > 0 Then
sBuffer = String$(50, 0)
sBuffer = Trim(ButtonText)
Ret = SendStringMessage(ToolBarWnd, TB_ADDSTRING, 0, sBuffer)
End If
 
Button.iBitmap = BitPic
Button.idCommand = id
Button.fsState = TBSTATE_ENABLED
Button.fsStyle = TBSTYLE_BUTTON Or NewStyle
Button.dwData = 0
Button.iString = id


Ret = SendMessage(ToolBarWnd, TB_ADDBUTTONS, 1, Button)

If xLarge = 1 Then

If ButtonWidth > 0 Then


lParam = ButtonWidth + (50 * 65536)
BInfo(id).xWidth = ButtonWidth
BInfo(id).xHeight = (50 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)

Else
If Len(ButtonText) > CaptionLen Then
lParam = ButtonWidth + (ButtonHeight * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
BInfo(id).xWidth = ButtonWidth
BInfo(id).xHeight = (ButtonHeight * 65536)

If Len(ButtonText) > 6 And Len(ButtonText) <= 11 Then

lParam = 50 * (Len(ButtonText) / 6.5) + (50 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
CaptionLen = Len(ButtonText)
BInfo(id).xWidth = 50 * (Len(ButtonText) / 6.5)
BInfo(id).xHeight = (50 * 65536)
 
Num = 50 * (Len(ButtonText) / 6.5)
Exit Sub

ElseIf Len(ButtonText) >= 12 And Len(ButtonText) <= 20 Then

lParam = 50 * (Len(ButtonText) / 7) + (50 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
CaptionLen = Len(ButtonText)
BInfo(id).xWidth = 50 * (Len(ButtonText) / 7)
BInfo(id).xHeight = (50 * 65536)
 
Num = 50 * (Len(ButtonText) / 7)
Exit Sub
ElseIf Len(ButtonText) >= 21 Then
  
 lParam = 50 * (Len(ButtonText) / 7.5) + (50 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
CaptionLen = Len(ButtonText)
BInfo(id).xWidth = 50 * (Len(ButtonText) / 7.5)
BInfo(id).xHeight = (50 * 65536)
 
Num = 50 * (Len(ButtonText) / 7.5)
Exit Sub
Else


lParam = 50 + (50 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
BInfo(id).xWidth = 50
BInfo(id).xHeight = (50 * 65536)
End If

Else
'Use larger one from past
 
lParam = Num + (50 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
 BInfo(id).xWidth = Num
BInfo(id).xHeight = (50 * 65536)


End If
End If
End If
End Sub
Public Sub ButtonSize(xWidth As Integer, xHeight As Integer)
On Error Resume Next
ButtonWidth = xWidth
ButtonHeight = xHeight

End Sub
Public Sub DisAbleButton(id As Integer)
 Dim Button As TBBUTTON
 'Comments are in the DisAbleButton32 procedure
 Call SendMessage(ToolBarWnd, TB_DELETEBUTTON, id, Button)
 
 Dim IdNums As Integer
 
 IdNums = id
 
 Button.iBitmap = BInfo(IdNums).BitMapNum
 Button.idCommand = BInfo(IdNums).idNum
 Button.fsState = TBSTATE_INDETERMINATE
 Button.fsStyle = TBSTYLE_BUTTON
 Button.dwData = 0
 Button.iString = id
   
 Dim lParam As Long, Ret As Long
  
 Call SendMessage(ToolBarWnd, TB_INSERTBUTTON, id, Button)
   
End Sub

Public Sub EnableButton(id As Integer)
 Dim Button As TBBUTTON
 'Comments are in the EnableButton32 procedure
 Call SendMessage(ToolBarWnd, TB_DELETEBUTTON, id, Button)
 
 Dim IdNums As Integer
 
 IdNums = id
  
 Button.iBitmap = BInfo(IdNums).BitMapNum
 Button.idCommand = BInfo(IdNums).idNum
 Button.fsState = TBSTATE_ENABLED
 Button.fsStyle = TBSTYLE_BUTTON
 Button.dwData = 0
 Button.iString = id
 
 Dim lParam As Long, Ret As Long

 Call SendMessage(ToolBarWnd, TB_INSERTBUTTON, id, Button)
  
End Sub
Public Function GetToolbarButtonTip(id As Integer)
On Error Resume Next
'Retrieves our Tooltips text assigned to this button
 GetToolbarButtonTip = BInfo(id).TipsText
End Function
Public Sub DisAbleButton32(id As Integer)

Dim Button As TBBUTTON
'Delete the button by sending the TB_DELETEBUTTON message
'with the structure of Button and the zero based position number
'of the button
Call SendMessage(ToolBarWnd, TB_DELETEBUTTON, id, Button)

Dim IdNums As Integer

IdNums = id

'Add the button information from our array to the new structure
'but instead of a normal button, we'll add a disabled one
Button.iBitmap = BInfo(IdNums).BitMapNum
Button.idCommand = BInfo(IdNums).idNum
Button.fsState = TBSTATE_INDETERMINATE
Button.fsStyle = TBSTYLE_BUTTON
Button.dwData = 0
Button.iString = id

'Insert the newly created button in the correct position (id)
Call SendMessage(ToolBarWnd, TB_INSERTBUTTON, id, Button)


Dim lParam As Long, Ret As Long
  
'Let's make sure the toolbar's buttons are the correct size
If ButtonWidth > 0 Then
lParam = ButtonWidth + (50 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
Else
'lParam = 50 + (50 * 65536)
lParam = BInfo(id).xWidth + (50 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
End If

End Sub
Public Sub EnAbleButton32(id As Integer)
Dim Button As TBBUTTON
'Delete the button by sending the TB_DELETEBUTTON message
'with the structure of Button and the zero based position number
'of the button
Call SendMessage(ToolBarWnd, TB_DELETEBUTTON, id, Button)

Dim IdNumsA As Integer

IdNumsA = id

'Add the button information from our array to the new structure
'but instead of a normal button, we'll add an enabled one
Button.iBitmap = BInfo(IdNumsA).BitMapNum
Button.idCommand = BInfo(IdNumsA).idNum
Button.fsState = TBSTATE_ENABLED
Button.fsStyle = TBSTYLE_BUTTON
Button.dwData = 0
Button.iString = id

'Insert the newly created button in the correct position (id)
Call SendMessage(ToolBarWnd, TB_INSERTBUTTON, id, Button)

Dim lParam As Long, Ret As Long
If ButtonWidth > 0 Then
lParam = ButtonWidth + (50 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
Else
'lParam = 50 + (50 * 65536)
lParam = BInfo(id).xWidth + (50 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
End If
End Sub
Public Sub CreateToolWindow(Optional ButtonSize As Integer = 16, Optional StyleList As Boolean, Optional WithText As Boolean, Optional Wrappable As Boolean, Optional PicSize As Integer)
On Error Resume Next

'Initialize Bitmap and Button
Dim tbab As TBADDBITMAP
Dim Button As TBBUTTON
 
Dim lParam As Long
Dim ListButtons As Boolean

Dim Wrap As Long
Dim List As Long

If StyleList = True Then
List = TBSTYLE_LIST
Else
List = 0
End If

If Wrappable = True Then
Wrap = TBSTYLE_WRAPABLE
Else
Wrap = 0
End If


'Create a Dummy toolbar to place the real one one
'This is needed so when you move the mouse away from the button
'it will repaint the button flat (Not required with IE 4.0)

'NOTE:  When creating the common controls through code, if you want to
'be able to resize you windows at will,
Toolbar = CreateWindowEX(0, "ToolbarWindow32", "", _
WS_CHILD Or WS_VISIBLE Or TB_AUTOSIZE Or Wrap Or List Or WS_CLIPCHILDREN _
Or WS_CLIPSIBLINGS Or CCS_NODIVIDER Or CCS_NOPARENTALIGN Or CCS_NORESIZE, _
0, 0, Parent.Height, Parent.Width, Parent.hWnd, 0&, ByVal App.hInstance, 0&)

'Create the Real one we will be using
ToolBarWnd = CreateWindowEX(0, "ToolbarWindow32", "", _
WS_CHILD Or WS_VISIBLE Or TB_AUTOSIZE Or Wrap Or List Or _
WS_CHILD Or CCS_NODIVIDER Or TBSTYLE_TOOLTIPS Or WS_CLIPCHILDREN _
Or CCS_NOPARENTALIGN Or CCS_NORESIZE Or TBSTYLE_FLAT, _
0, 0, 0, 0, Toolbar, 0&, App.hInstance, 0&)
 
'Let's send all the toolbar messages to our subclassed form
Call SendMessage(Toolbar, TB_SETPARENT, Parent.hWnd, 0)
Call SendMessage(ToolBarWnd, TB_SETPARENT, ToolBarMainParentForMessages.hWnd, 0)

'Resize the Toolbar to make sure we can see it
Call MoveWindow(ToolBarWnd, 0, 0, 850, 38, True)

'Send the structure to the toolbar
Ret = SendMessageByval(ToolBarWnd, TB_BUTTONSTRUCTSIZE, LenB(Button), 0)

'If we are using an odd shapped bitmap then
If PicSize > 0 Then
lParam = PicSize + (PicSize * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBITMAPSIZE, 0, lParam)
'Else let's use the buttonsize (usually 16 or 32)
Else
lParam = ButtonSize + (ButtonSize * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBITMAPSIZE, 0, lParam)
End If

'Let's add the Image source
tbab.hInst = 0
tbab.nID = ImgSource.Picture.Handle

'Add the bitmap containing button images to the toolbar.
Ret = SendMessage(ToolBarWnd, TB_ADDBITMAP, 50, tbab)

'Tell the toolbar the size of the buttons
If ButtonSize = 16 And WithText = False Then
lParam = 16 + (16 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
ElseIf ButtonSize = 16 And WithText = True Then 'Else
lParam = ButtonSize + (ButtonSize * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
ElseIf ButtonSize = 32 And WithText = False Then 'Else
lParam = ButtonSize + (ButtonSize * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
ElseIf ButtonSize = 32 And WithText = True Then
lParam = 50 + (50 * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
Else
lParam = ButtonSize + (ButtonSize * 65536)
Ret = SendMessageByval(ToolBarWnd, TB_SETBUTTONSIZE, 0, lParam)
End If
End Sub

 Public Sub Resize(frm As Object)
 On Error Resume Next
'We need to Hide the toolbars so they will repaint
'correctly.  Not required with IE 4.0 updated files

Call ShowWindow(Toolbar, SW_HIDE)
Call ShowWindow(ToolBarWnd, SW_HIDE)

'Resize toolbars
Call MoveWindow(Toolbar, 2, 2, frm.Width / Screen.TwipsPerPixelX - 5, frm.Height / Screen.TwipsPerPixelY - 5, True)
Call MoveWindow(ToolBarWnd, 0, 0, frm.Width / Screen.TwipsPerPixelX - 5, frm.Height / Screen.TwipsPerPixelY - 5, True)

'Update the Windows
Call UpdateWindow(Toolbar)
Call UpdateWindow(ToolBarWnd)

'Show the Toolbars
Call ShowWindow(Toolbar, SW_SHOW)
Call ShowWindow(ToolBarWnd, SW_SHOW)
End Sub
Public Sub PressButton(id As Integer)
On Error Resume Next
 
 'Initialize button structure
 Dim Button As TBBUTTON
 
 'Check the button
 Call SendMessage(ToolBarWnd, TB_CHECKBUTTON, id, Button)
 'Update the Window
 Call UpdateWindow(ToolBarWnd)
 
End Sub
