VERSION 5.00
Begin VB.Form Form1 
   BackColor       =   &H00000000&
   Caption         =   "Form1"
   ClientHeight    =   8415
   ClientLeft      =   1470
   ClientTop       =   1185
   ClientWidth     =   12885
   LinkTopic       =   "Form1"
   ScaleHeight     =   8415
   ScaleWidth      =   12885
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   5850
      Top             =   3960
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const PI = 3.14159265358979

Private Enum TipoMovimientoConstants
    tmvLeft
    tmvRight
    tmvUp
    tmvDown
    tmvAgainstClock
    tmvClock
End Enum

Private Type Punto
    X   As Single
    Y   As Single
    Z   As Single
End Type

Private Type Linea
    IDPto1  As Integer
    IDPto2  As Integer
    Color   As OLE_COLOR
End Type

Private Type Figura
    Centro      As Punto
    Puntos()    As Punto
    Lineas()    As Linea
End Type

Private Figuras()   As Figura
Private MovimientoX As Single
Private MovimientoY As Single
Private MovimientoZ As Single

Private Function Pow(Number, Exp As Integer) As Double
    Dim auxI As Integer

    Pow = 1
    For auxI = 1 To Exp
        Pow = Pow * Number
    Next auxI
End Function

Private Function Angle(X As Single, Y As Single)
    Angle = Atn(Y / X) - IIf(X < 0, PI, 0)
End Function

Private Sub CreaCubo(Fig As Figura)
    ReDim Fig.Puntos(1 To 8)

    Fig.Centro.X = (Me.Width / 4)
    Fig.Centro.Y = (Me.Height / 4)
    Fig.Centro.Z = 0

    Fig.Puntos(1).X = -1000
    Fig.Puntos(1).Y = 1000
    Fig.Puntos(1).Z = 1000

    Fig.Puntos(2).X = 1000
    Fig.Puntos(2).Y = 1000
    Fig.Puntos(2).Z = 1000

    Fig.Puntos(3).X = 1000
    Fig.Puntos(3).Y = -1000
    Fig.Puntos(3).Z = 1000

    Fig.Puntos(4).X = -1000
    Fig.Puntos(4).Y = -1000
    Fig.Puntos(4).Z = 1000

    Fig.Puntos(5).X = -1000
    Fig.Puntos(5).Y = -1000
    Fig.Puntos(5).Z = -1000

    Fig.Puntos(6).X = 1000
    Fig.Puntos(6).Y = -1000
    Fig.Puntos(6).Z = -1000

    Fig.Puntos(7).X = 1000
    Fig.Puntos(7).Y = 1000
    Fig.Puntos(7).Z = -1000

    Fig.Puntos(8).X = -1000
    Fig.Puntos(8).Y = 1000
    Fig.Puntos(8).Z = -1000


    ReDim Fig.Lineas(1 To 12)

    Fig.Lineas(1).IDPto1 = 1
    Fig.Lineas(1).IDPto2 = 2
    Fig.Lineas(1).Color = vbBlue

    Fig.Lineas(2).IDPto1 = 2
    Fig.Lineas(2).IDPto2 = 3
    Fig.Lineas(2).Color = vbBlue

    Fig.Lineas(3).IDPto1 = 3
    Fig.Lineas(3).IDPto2 = 4
    Fig.Lineas(3).Color = vbBlue

    Fig.Lineas(4).IDPto1 = 4
    Fig.Lineas(4).IDPto2 = 1
    Fig.Lineas(4).Color = vbBlue

    Fig.Lineas(5).IDPto1 = 5
    Fig.Lineas(5).IDPto2 = 6
    Fig.Lineas(5).Color = vbBlue

    Fig.Lineas(6).IDPto1 = 6
    Fig.Lineas(6).IDPto2 = 7
    Fig.Lineas(6).Color = vbBlue

    Fig.Lineas(7).IDPto1 = 7
    Fig.Lineas(7).IDPto2 = 8
    Fig.Lineas(7).Color = vbBlue

    Fig.Lineas(8).IDPto1 = 8
    Fig.Lineas(8).IDPto2 = 5
    Fig.Lineas(8).Color = vbBlue

    Fig.Lineas(9).IDPto1 = 1
    Fig.Lineas(9).IDPto2 = 8
    Fig.Lineas(9).Color = vbBlue

    Fig.Lineas(10).IDPto1 = 2
    Fig.Lineas(10).IDPto2 = 7
    Fig.Lineas(10).Color = vbBlue

    Fig.Lineas(11).IDPto1 = 3
    Fig.Lineas(11).IDPto2 = 6
    Fig.Lineas(11).Color = vbBlue

    Fig.Lineas(12).IDPto1 = 4
    Fig.Lineas(12).IDPto2 = 5
    Fig.Lineas(12).Color = vbBlue
End Sub

Private Sub CreaCuboConDiagonales(Fig As Figura)
    Call CreaCubo(Fig)

    ReDim Preserve Fig.Lineas(1 To 24)

    Fig.Centro.X = (Me.Width / 4) * 3
    Fig.Centro.Y = (Me.Height / 4)
    Fig.Centro.Z = 0

    'Diagonales
    Fig.Lineas(13).IDPto1 = 1
    Fig.Lineas(13).IDPto2 = 3
    Fig.Lineas(13).Color = vbBlue

    Fig.Lineas(14).IDPto1 = 2
    Fig.Lineas(14).IDPto2 = 4
    Fig.Lineas(14).Color = vbBlue

    Fig.Lineas(15).IDPto1 = 5
    Fig.Lineas(15).IDPto2 = 7
    Fig.Lineas(15).Color = vbBlue

    Fig.Lineas(16).IDPto1 = 6
    Fig.Lineas(16).IDPto2 = 8
    Fig.Lineas(16).Color = vbBlue

    Fig.Lineas(17).IDPto1 = 1
    Fig.Lineas(17).IDPto2 = 5
    Fig.Lineas(17).Color = vbBlue

    Fig.Lineas(18).IDPto1 = 2
    Fig.Lineas(18).IDPto2 = 6
    Fig.Lineas(18).Color = vbBlue

    Fig.Lineas(19).IDPto1 = 3
    Fig.Lineas(19).IDPto2 = 7
    Fig.Lineas(19).Color = vbBlue

    Fig.Lineas(20).IDPto1 = 4
    Fig.Lineas(20).IDPto2 = 8
    Fig.Lineas(20).Color = vbBlue

    Fig.Lineas(21).IDPto1 = 1
    Fig.Lineas(21).IDPto2 = 7
    Fig.Lineas(21).Color = vbBlue

    Fig.Lineas(22).IDPto1 = 2
    Fig.Lineas(22).IDPto2 = 8
    Fig.Lineas(22).Color = vbBlue

    Fig.Lineas(23).IDPto1 = 3
    Fig.Lineas(23).IDPto2 = 5
    Fig.Lineas(23).Color = vbBlue

    Fig.Lineas(24).IDPto1 = 4
    Fig.Lineas(24).IDPto2 = 6
    Fig.Lineas(24).Color = vbBlue
End Sub

Private Sub CreaEstrella(Fig As Figura)
    ReDim Fig.Puntos(1 To 8)

    Fig.Centro.X = (Me.Width / 4)
    Fig.Centro.Y = (Me.Height / 4) * 3
    Fig.Centro.Z = 0

    Fig.Puntos(1).X = -1000
    Fig.Puntos(1).Y = 1000
    Fig.Puntos(1).Z = 1000

    Fig.Puntos(2).X = 1000
    Fig.Puntos(2).Y = 1000
    Fig.Puntos(2).Z = 1000

    Fig.Puntos(3).X = 1000
    Fig.Puntos(3).Y = -1000
    Fig.Puntos(3).Z = 1000

    Fig.Puntos(4).X = -1000
    Fig.Puntos(4).Y = -1000
    Fig.Puntos(4).Z = 1000

    Fig.Puntos(5).X = -1000
    Fig.Puntos(5).Y = -1000
    Fig.Puntos(5).Z = -1000

    Fig.Puntos(6).X = 1000
    Fig.Puntos(6).Y = -1000
    Fig.Puntos(6).Z = -1000

    Fig.Puntos(7).X = 1000
    Fig.Puntos(7).Y = 1000
    Fig.Puntos(7).Z = -1000

    Fig.Puntos(8).X = -1000
    Fig.Puntos(8).Y = 1000
    Fig.Puntos(8).Z = -1000


    ReDim Fig.Lineas(1 To 12)

    Fig.Lineas(1).IDPto1 = 1
    Fig.Lineas(1).IDPto2 = 3
    Fig.Lineas(1).Color = vbBlue

    Fig.Lineas(2).IDPto1 = 2
    Fig.Lineas(2).IDPto2 = 4
    Fig.Lineas(2).Color = vbBlue

    Fig.Lineas(3).IDPto1 = 5
    Fig.Lineas(3).IDPto2 = 7
    Fig.Lineas(3).Color = vbBlue

    Fig.Lineas(4).IDPto1 = 6
    Fig.Lineas(4).IDPto2 = 8
    Fig.Lineas(4).Color = vbBlue

    Fig.Lineas(5).IDPto1 = 1
    Fig.Lineas(5).IDPto2 = 5
    Fig.Lineas(5).Color = vbBlue

    Fig.Lineas(6).IDPto1 = 2
    Fig.Lineas(6).IDPto2 = 6
    Fig.Lineas(6).Color = vbBlue

    Fig.Lineas(7).IDPto1 = 3
    Fig.Lineas(7).IDPto2 = 7
    Fig.Lineas(7).Color = vbBlue

    Fig.Lineas(8).IDPto1 = 4
    Fig.Lineas(8).IDPto2 = 8
    Fig.Lineas(8).Color = vbBlue

    Fig.Lineas(9).IDPto1 = 1
    Fig.Lineas(9).IDPto2 = 7
    Fig.Lineas(9).Color = vbBlue

    Fig.Lineas(10).IDPto1 = 2
    Fig.Lineas(10).IDPto2 = 8
    Fig.Lineas(10).Color = vbBlue

    Fig.Lineas(11).IDPto1 = 3
    Fig.Lineas(11).IDPto2 = 5
    Fig.Lineas(11).Color = vbBlue

    Fig.Lineas(12).IDPto1 = 4
    Fig.Lineas(12).IDPto2 = 6
    Fig.Lineas(12).Color = vbBlue
End Sub

Private Sub CreaPiramide(Fig As Figura)
    ReDim Fig.Puntos(1 To 4)

    Fig.Centro.X = (Me.Width / 4) * 3
    Fig.Centro.Y = (Me.Height / 4) * 3
    Fig.Centro.Z = 0

    Fig.Puntos(1).X = -1000
    Fig.Puntos(1).Y = 1000
    Fig.Puntos(1).Z = 1000

    Fig.Puntos(2).X = 1000
    Fig.Puntos(2).Y = -1000
    Fig.Puntos(2).Z = 1000

    Fig.Puntos(3).X = -1000
    Fig.Puntos(3).Y = -1000
    Fig.Puntos(3).Z = -1000

    Fig.Puntos(4).X = 1000
    Fig.Puntos(4).Y = 1000
    Fig.Puntos(4).Z = -1000


    ReDim Fig.Lineas(1 To 6)

    Fig.Lineas(1).IDPto1 = 1
    Fig.Lineas(1).IDPto2 = 2
    Fig.Lineas(1).Color = vbBlue

    Fig.Lineas(2).IDPto1 = 3
    Fig.Lineas(2).IDPto2 = 4
    Fig.Lineas(2).Color = vbBlue

    Fig.Lineas(3).IDPto1 = 1
    Fig.Lineas(3).IDPto2 = 3
    Fig.Lineas(3).Color = vbBlue

    Fig.Lineas(4).IDPto1 = 2
    Fig.Lineas(4).IDPto2 = 4
    Fig.Lineas(4).Color = vbBlue

    Fig.Lineas(5).IDPto1 = 1
    Fig.Lineas(5).IDPto2 = 4
    Fig.Lineas(5).Color = vbBlue

    Fig.Lineas(6).IDPto1 = 2
    Fig.Lineas(6).IDPto2 = 3
    Fig.Lineas(6).Color = vbBlue
End Sub

Private Sub DibujaFigura(Fig As Figura, Optional Limpiar As Boolean = False)
    Dim auxI As Integer

    Me.PSet (Fig.Centro.X, Fig.Centro.Y), vbGreen
    For auxI = 1 To 6
        Me.Circle (Fig.Centro.X, Fig.Centro.Y), auxI * 5, IIf(Limpiar, Me.BackColor, vbGreen)
    Next auxI
    Me.DrawStyle = vbDot
    Me.Line (Fig.Centro.X - 1950, Fig.Centro.Y)-(Fig.Centro.X + 1950, Fig.Centro.Y), vbGreen
    Me.Line (Fig.Centro.X, Fig.Centro.Y - 1950)-(Fig.Centro.X, Fig.Centro.Y + 1950), vbGreen

    Me.DrawStyle = vbSolid
    For auxI = LBound(Fig.Puntos) To UBound(Fig.Puntos)
        Me.Circle (Fig.Centro.X + Fig.Puntos(auxI).X, Fig.Centro.Y + Fig.Puntos(auxI).Y), 60, IIf(Limpiar, Me.BackColor, vbRed)
    Next auxI

    For auxI = LBound(Fig.Lineas) To UBound(Fig.Lineas)
        'If Fig.Lineas(auxI).Color <> vbGreen Then
        Me.Line (Fig.Centro.X + Fig.Puntos(Fig.Lineas(auxI).IDPto1).X, Fig.Centro.Y + Fig.Puntos(Fig.Lineas(auxI).IDPto1).Y)-(Fig.Centro.X + Fig.Puntos(Fig.Lineas(auxI).IDPto2).X, Fig.Centro.Y + Fig.Puntos(Fig.Lineas(auxI).IDPto2).Y), IIf(Limpiar, Me.BackColor, Fig.Lineas(auxI).Color)
    Next auxI
End Sub

Private Sub MueveFigura(Fig As Figura)
    Dim auxI As Integer

    For auxI = LBound(Fig.Puntos) To UBound(Fig.Puntos)
        Call MuevePunto(Fig.Puntos(auxI))
    Next auxI
End Sub

Private Sub MuevePunto(Pto As Punto)
    Dim Angulo  As Double
    Dim xRadio  As Double

    If MovimientoX <> 0 Then
        xRadio = Sqr(Pow(Pto.X, 2) + Pow(Pto.Z, 2))
        Angulo = Angle(Pto.X, Pto.Z)
        Angulo = Angulo + MovimientoX
        Pto.X = xRadio * Cos(Angulo)
        Pto.Y = Pto.Y
        Pto.Z = xRadio * Sin(Angulo)
    End If

    If MovimientoY <> 0 Then
        xRadio = Sqr(Pow(Pto.Y, 2) + Pow(Pto.Z, 2))
        Angulo = Angle(Pto.Y, Pto.Z)
        Angulo = Angulo + MovimientoY
        Pto.X = Pto.X
        Pto.Y = xRadio * Cos(Angulo)
        Pto.Z = xRadio * Sin(Angulo)
    End If

    If MovimientoZ <> 0 Then
        xRadio = Sqr(Pow(Pto.X, 2) + Pow(Pto.Y, 2))
        Angulo = Angle(Pto.X, Pto.Y)
        Angulo = Angulo + MovimientoZ
        Pto.X = xRadio * Cos(Angulo)
        Pto.Y = xRadio * Sin(Angulo)
        Pto.Z = Pto.Z
    End If
End Sub

Private Sub Form_Activate()
    ReDim Figuras(1 To 4) As Figura
    Dim auxI As Integer

    Call CreaCubo(Figuras(1))
    Call CreaCuboConDiagonales(Figuras(2))
    Call CreaEstrella(Figuras(3))
    Call CreaPiramide(Figuras(4))

    For auxI = LBound(Figuras) To UBound(Figuras)
        Call DibujaFigura(Figuras(auxI))
    Next auxI
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    Dim auxI As Integer

    For auxI = LBound(Figuras) To UBound(Figuras)
        Select Case KeyCode
            Case 37
                MovimientoX = Round(MovimientoX - 0.01, 2)
            Case 38
                MovimientoY = Round(MovimientoY - 0.01, 2)
            Case 39
                MovimientoX = Round(MovimientoX + 0.01, 2)
            Case 40
                MovimientoY = Round(MovimientoY + 0.01, 2)
            Case 65
                MovimientoZ = Round(MovimientoZ - 0.01, 2)
            Case 83
                MovimientoZ = Round(MovimientoZ + 0.01, 2)
        End Select

        If MovimientoX <> 0 Or MovimientoY <> 0 Or MovimientoZ <> 0 Then
            Timer1.Enabled = True
        Else
            Timer1.Enabled = False
        End If
    Next auxI
End Sub

Private Sub Timer1_Timer()
    Dim auxI As Integer

    For auxI = LBound(Figuras) To UBound(Figuras)
        Call DibujaFigura(Figuras(auxI), True)

        Call MueveFigura(Figuras(auxI))

        Call DibujaFigura(Figuras(auxI))
    Next auxI
End Sub
