Attribute VB_Name = "Module1"
Option Explicit

Private m_Vista As Long

Public Archivo As String

'constantes para las versiones de windows
Private Const VER_PLATFORM_WIN32_NT As Long = 2
Private Const OSV_LENGTH As Long = 76
Private Const OSVEX_LENGTH As Long = 88
Public OSV_VERSION_LENGTH As Long 'our const to hold appropriate OSV length

'Estructura OSVERSIONINFO
Private Type OSVERSIONINFO
  OSVSize         As Long
  dwVerMajor      As Long
  dwVerMinor      As Long
  dwBuildNumber   As Long
  PlatformID      As Long
  szCSDVersion    As String * 128
End Type

'Declaracin mensajes y notificaciones
Private Const WM_COMMAND = &H111
Public Const WM_NOTIFY As Long = &H4E&
Public Const WM_INITDIALOG As Long = &H110
Public Const CDN_FIRST As Long = -601
Public Const CDN_INITDONE As Long = (CDN_FIRST - &H0&)
Public Const MAX_PATH As Long = 260

'Constantes para openfilename
Public Const OFN_ENABLEHOOK As Long = &H20
Public Const OFN_EXPLORER As Long = &H80000
Public Const OFN_ENABLESIZING As Long = &H800000
Public Const OFN_EX_NOPLACESBAR As Long = &H1

'Declaracin de la estructura OPENFILENAME
Public Type OPENFILENAME
  nStructSize       As Long
  hwndOwner         As Long
  hInstance         As Long
  sFilter           As String
  sCustomFilter     As String
  nMaxCustFilter    As Long
  nFilterIndex      As Long
  sFile             As String
  nMaxFile          As Long
  sFileTitle        As String
  nMaxTitle         As Long
  sInitialDir       As String
  sDialogTitle      As String
  Flags             As Long
  nFileOffset       As Integer
  nFileExtension    As Integer
  sDefFileExt       As String
  nCustData         As Long
  fnHook            As Long
  sTemplateName     As String
  pvReserved        As Long
  dwReserved        As Long
  flagsEx           As Long
End Type

'Variable para utilizar la estructura OPENFILENAME que tiene los datos _
para el Commondialog de windows
Public OFN As OPENFILENAME

'Api GetVersionEx para recuperar la version del sistema operativo
Private Declare Function GetVersionEx Lib "kernel32" _
   Alias "GetVersionExA" _
  (lpVersionInformation As Any) As Long
  
'Api GetOpenFileName para el CommonDialog
Public Declare Function GetOpenFileName Lib "comdlg32.dll" _
   Alias "GetOpenFileNameA" _
  (pOpenfilename As OPENFILENAME) As Long

'Api FindWindowEx
Private Declare Function FindWindowEx Lib "user32" _
   Alias "FindWindowExA" _
  (ByVal hWndParent As Long, _
   ByVal hWndChildAfter As Long, _
   ByVal lpClassName As String, _
   ByVal lpWindowName As String) As Long

'Api GetParent
Private Declare Function GetParent Lib "user32" _
  (ByVal hWnd As Long) As Long

'Api SendMessage
Private Declare Function SendMessage Lib "user32" _
   Alias "SendMessageA" _
   (ByVal hWnd As Long, _
    ByVal wMsg As Long, _
    ByVal wParam As Long, _
    lParam As Any) As Long

Public Function Abrir(form As Object, m_DialogTitle As String, _
                      m_Filter As String, m_InitDir As String, _
                      Vista As Long, m_Flags, m_FileName, m_FileTitle _
                      As String) As String
 
 
 Dim sFilters As String
   Dim OFN As OPENFILENAME
   
   If m_Flags = 0 Then
      m_Flags = OFN_EXPLORER Or OFN_ENABLEHOOK Or OFN_ENABLESIZING
   End If
   If OSV_VERSION_LENGTH = 0 Then SetOSVersion
   
  'reemplazamos el caracter | por un chr(0) para el Filtro
   sFilters = Replace(m_Filter, "|", Chr$(0))
   
   m_Vista = Vista2(Vista)
 
  'llenamos la estructura OpenFileName
   With OFN
      .nStructSize = OSV_VERSION_LENGTH
      
      'Hwnd del formulario que utiliza el commondialog
      .hwndOwner = form.hWnd
      'Propiedad Filter
      .sFilter = sFilters + Chr$(0)
      .nFilterIndex = 0
       If m_FileName = "" Then
          m_FileName = vbNullChar
       End If
      .sFile = m_FileName & Space$(MAX_PATH) & vbNullChar & vbNullChar
      .nMaxFile = Len(.sFile)
      .sDefFileExt = "*.bmp" & vbNullChar & vbNullChar
      .sFileTitle = vbNullChar & Space$(512) & vbNullChar & vbNullChar
      .nMaxTitle = Len(OFN.sFileTitle)
      'directorio inicial del CommonDialog
      .sInitialDir = m_InitDir & vbNullChar & vbNullChar
      'Titulo del CommonDialog
      .sDialogTitle = m_DialogTitle
      'flags del CommonDialog
      .Flags = m_Flags
      'Direccin del Hook
      .fnHook = FARPROC(AddressOf OFNHookProc)

   End With


  
  
  Call GetOpenFileName(OFN)

 If Asc(Mid(OFN.sFile, 1, 1)) <> 0 Then
   Abrir = Trim$(Replace(OFN.sFile, Chr$(0), vbNullString))
   Archivo = Trim$(Replace(OFN.sFileTitle, Chr$(0), vbNullString))
  Else
   Abrir = ""
 End If
End Function


Public Function Vista2(ByVal Valor As Long) As Long
   
'VISTA_LISTA = 28715 'vista Lista
'VISTA_MOSAICO = 28718 'vista de Mosaicos
'VISTA_THUMBNAIL = 28717 ' vista Thumbnail - Vista miniatura
'VISTA_ICONOS = 28713 'vista de iconos
'VISTA_DETALLE = 28716 'vista detallada
   
   Select Case Valor
        Case 0: Vista2 = 28715
        Case 1: Vista2 = 28718
        Case 2: Vista2 = 28717
        Case 3: Vista2 = 28713
        Case 4: Vista2 = 28716
   End Select
   
   
End Function


Public Function FARPROC(pfn As Long) As Long
  
FARPROC = pfn

End Function


Public Function IsWin2000Plus() As Boolean

  'returns True if running Windows 2000 or later
   Dim osv As OSVERSIONINFO

   osv.OSVSize = Len(osv)

   If GetVersionEx(osv) = 1 Then
   
      IsWin2000Plus = (osv.PlatformID = VER_PLATFORM_WIN32_NT) And _
                      (osv.dwVerMajor = 5 And osv.dwVerMinor >= 0)
  
   End If

End Function

Public Function OFNHookProc(ByVal hWnd As Long, _
                            ByVal uMsg As Long, _
                            ByVal wParam As Long, _
                            ByVal lParam As Long) As Long

   Dim hWndParent As Long
   Dim hwndLv As Long
   Static bLvSetupDone As Boolean
   
   Select Case uMsg
      Case WM_INITDIALOG

         bLvSetupDone = False

      
      Case WM_NOTIFY
               
            If bLvSetupDone = False Then
               
               'Hwnd del CommonDialog
               hWndParent = GetParent(hWnd)
               hwndLv = FindWindowEx(hWndParent, 0, "SHELLDLL_DefView", vbNullChar)
               
               If hwndLv > 0 Then
                  Call SendMessage(hwndLv, WM_COMMAND, ByVal m_Vista, ByVal 0&)

                  bLvSetupDone = True
               End If

            End If

         Case Else
         
   End Select

End Function


Public Sub SetOSVersion()
  Select Case IsWin2000Plus()
      Case True
         OSV_VERSION_LENGTH = OSVEX_LENGTH
      
      Case Else
         OSV_VERSION_LENGTH = OSV_LENGTH
   End Select

End Sub




