VERSION 5.00
Begin VB.UserControl CdView 
   BackColor       =   &H000080FF&
   ClientHeight    =   480
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   480
   InvisibleAtRuntime=   -1  'True
   Picture         =   "cDialogVistas.ctx":0000
   ScaleHeight     =   480
   ScaleWidth      =   480
   ToolboxBitmap   =   "cDialogVistas.ctx":03BD
End
Attribute VB_Name = "CdView"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'Para las copias locales de las propiedades
'**********************************************
Private m_FileName As String
Private m_Filter As String
Private m_DialogTitle As String
Private m_InitDir As String
Private m_Vista As Long
Private m_Flags As Long
Private m_FileTitle As String

'Enum para los tipos de vista del commonDialog _
***********************************************
Enum e_Vista
  VISTA_LISTA ' = 28715 'vista Lista
  VISTA_MOSAICO '= 28718 'vista de Mosaicos
  VISTA_THUMBNAIL '= 28717 ' vista Thumbnail - Vista miniatura
  VISTA_ICONOS '= 28713 'vista de iconos
  VISTA_DETALLE '= 28716 'vista detallada
End Enum

'Funcin que abre el CommonDialog
'*****************************************
Public Function ShowOpen(form As Object)
m_FileName = Abrir(form, m_DialogTitle, m_Filter, _
             m_InitDir, m_Vista, m_Flags, m_FileName, m_FileTitle)
             
m_FileTitle = Archivo
PropertyChanged "FileTitle"
End Function


'*****************************************
'Propiedades
'*****************************************

'Propiedad FileName: Nombre de archivo
Public Property Get FileName() As String
FileName = m_FileName
End Property

Public Property Let FileName(ByVal vNewValue As String)
m_FileName = vNewValue
PropertyChanged "FileName"
End Property

'Propiedad Filter: Extenciones
Public Property Get Filter() As Variant
Filter = m_Filter
End Property

Public Property Let Filter(ByVal vNewValue As Variant)
m_Filter = vNewValue
PropertyChanged "Filter"
End Property

'Propiedad DialogTitle: Texto para el ttulo del cuadro de dilogo
Public Property Get DialogTitle() As String
DialogTitle = m_DialogTitle
End Property

Public Property Let DialogTitle(ByVal vNewValue As String)
m_DialogTitle = vNewValue
PropertyChanged "DialogTitle"
End Property

'Propiedad InitDir: Directorio inicial del cuadro de dilogo
Public Property Get InitDir() As Variant
InitDir = m_InitDir
End Property

Public Property Let InitDir(ByVal vNewValue As Variant)
m_InitDir = vNewValue
PropertyChanged "InitDir"
End Property

'Propiedad Vista: Tipos de vista del CommonDialog:
'Iconos, detalle, Mosaico, Miniatura etc..
Public Property Get Vista() As e_Vista
Vista = m_Vista
End Property

Public Property Let Vista(ByVal vNewValue As e_Vista)
m_Vista = vNewValue
PropertyChanged "Vista"
End Property

'Propiedad Flags: opciones del Commondialog
Public Property Get Flags() As Long
m_Flags = Flags
End Property

Public Property Let Flags(ByVal vNewValue As Long)
m_Flags = vNewValue
PropertyChanged "Flags"
End Property

'Propiedad FileTitle: Nombre del Archivo Seleccionado
Public Property Get FileTitle() As String
 FileTitle = m_FileTitle
End Property

Public Property Let FileTitle(ByVal vNewValue As String)
m_FileTitle = vNewValue
PropertyChanged "FileTitle"
End Property


Private Sub UserControl_Initialize()
'Vista por defecto del Commondialg en Thumbnail al agregarlo al form
m_Vista = VISTA_THUMBNAIL
m_Flags = 0
End Sub


'Cargar valores de propiedad desde el almacn
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)

    InitDir = PropBag.ReadProperty("InitDir", "")
    Vista = PropBag.ReadProperty("Vista", 2)
    Filter = PropBag.ReadProperty("Filter", "*.*")
    DialogTitle = PropBag.ReadProperty("DialogTitle", "Abrir")
    FileName = PropBag.ReadProperty("FileName", "")
    Flags = PropBag.ReadProperty("Flags", 0)
    FileTitle = PropBag.ReadProperty("FileTitle", "")
End Sub

'Escribir valores de propiedad en el almacn
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)

    Call PropBag.WriteProperty("InitDir", m_InitDir, "")
    Call PropBag.WriteProperty("Vista", m_Vista, 2)
    Call PropBag.WriteProperty("Filter", m_Filter, "*.*")
    Call PropBag.WriteProperty("DialogTitle", m_DialogTitle, "Abrir")
    Call PropBag.WriteProperty("FileName", m_FileName, "")
    Call PropBag.WriteProperty("Flags", m_Flags, 0)
    Call PropBag.WriteProperty("FileTitle", m_FileTitle, "")
End Sub

Private Sub UserControl_Resize()
UserControl.Width = 485
UserControl.Height = 485
End Sub
