Option Explicit On


Public Class Form2
    ' variables
    ''' '''''''''''''''''''''''''''''''''''''''''
    Public mPath As String = ""
    Public mEscalaActual As Double

    ' Aumentar o reducir la imagen 
    ''' ''''''''''''''''''''''''''''''''''''''
    
    Private Sub zoom(ByVal Picbox As PictureBox, ByVal Escala As Single)

        With Picbox
            ' modo de ajuste en zoom
            .SizeMode = PictureBoxSizeMode.Zoom

            Dim ancho As Integer = .Image.Width
            Dim alto As Integer = .Image.Height

            ' Comprobar si la nueva dimensin  no es menor a 16 pixeles
            If (ancho * Escala) > 16 And (alto * Escala) > 16 Then
                ' Establecer nuevo ancho y alto
                .Width = ancho * Escala
                .Height = alto * Escala

                Centrar_Picturebox()

                mEscalaActual = Escala

            End If
        End With
    End Sub
    ' descargar form
    Private Sub Form2_FormClosed( _
        ByVal sender As Object, _
        ByVal e As System.Windows.Forms.FormClosedEventArgs) _
            Handles Me.FormClosed

        Me.Hide()
        Me.Dispose()

    End Sub
    ' Opciones de evento de tecla del formulario
    Private Sub Form2_KeyDown( _
        ByVal sender As Object, _
        ByVal e As System.Windows.Forms.KeyEventArgs) _
            Handles Me.KeyDown

        Select Case e.KeyCode
            ' tecla escape
            Case Keys.Escape
                Me.Close()
                ' tecla +
            Case Keys.Add
                zoom(PictureBox1, mEscalaActual + 0.1)
                ' tecla -
            Case Keys.Subtract
                zoom(PictureBox1, mEscalaActual - 0.1)
            Case Keys.Enter
                Me.Close()
                ' mover a la siguiente imagen
            Case Keys.Right
                Static i As Integer = 0
                With Form1.ListView1
                    If i = .Items.Count - 1 Then
                        i = 0
                    Else
                        i = i + 1
                    End If
                    .Items(i).Selected = True
                    iniciar(.Items(i).ImageKey.ToString)
                End With
        End Select

    End Sub
    Private Sub Form1_Load(ByVal sender As System.Object, _
                           ByVal e As System.EventArgs) _
                           Handles MyBase.Load
        Me.BackColor = Color.Black
        ' form sin borde ni title bar
        Me.FormBorderStyle = Windows.Forms.FormBorderStyle.None
        PictureBox1.BackColor = Color.Black
        iniciar(mPath.ToString)

    End Sub
    ' cargar la imagen al iniciar
    Private Sub iniciar(ByVal sRuta As String)
        Try
            With PictureBox1
                mEscalaActual = 1
                If System.IO.File.Exists(sRuta) Then
                    .Cursor = Cursors.Hand
                    .SizeMode = PictureBoxSizeMode.AutoSize
                    ' leer la imagen con FromFile 
                    .Image = Image.FromFile(sRuta)
                    ' centrar en el formulario
                    Centrar_Picturebox()
                Else
                    Me.Close()
                End If
            End With
        Catch ex As OutOfMemoryException
            Me.Close()
        Catch ex As Exception
            MsgBox(ex.Message.ToString)
        End Try
    End Sub
    ' descargar al hacer dobleclic en el formulario
    Private Sub Form2_MouseDoubleClick( _
        ByVal sender As Object, _
        ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseDoubleClick
        Me.Close()
    End Sub


    Private Sub Centrar_Picturebox()
        With PictureBox1
            .Top = (Me.Height - .Height) \ 2
            .Left = (Me.Width - .Width) \ 2
        End With
    End Sub

    Private Sub PictureBox1_MouseDown1( _
        ByVal sender As Object, _
        ByVal e As System.Windows.Forms.MouseEventArgs) _
            Handles PictureBox1.MouseDown

        Select Case e.Button
            ' Aumentar con el botn izquierdo
            Case Windows.Forms.MouseButtons.Left
                zoom(PictureBox1, mEscalaActual + 0.2)
                ' Reducir con el botn derecho
            Case Windows.Forms.MouseButtons.Right
                zoom(PictureBox1, mEscalaActual - 0.2)
        End Select
    End Sub
End Class