Option Explicit On
Option Strict On

Imports System.IO

Public Class Form1

    ' Variables
    ' '''''''''''''''''''''''''''''

    ' Objeto NotifyIcon con evento para colocar el formulario en el tray
    Private WithEvents mNotifyIcon As New NotifyIcon


    ' Subs y funciones
    ' ''''''''''''''''''''''''''''

    ' botn que abre el dilogo para seleccionar el directorio a monitorear
    Private Sub btnPath_Click(ByVal sender As System.Object, _
                              ByVal e As System.EventArgs) Handles btnPath.Click

        Dim oFolderBrowser As New FolderBrowserDialog

        With oFolderBrowser
            .SelectedPath = ""
            If .ShowDialog = Windows.Forms.DialogResult.OK Then
                txtPath.Text = .SelectedPath
                .Dispose()
                cambiar_FSW(FileSystemWatcher1)
            End If
        End With
    End Sub

    ' elimina en el mNotifyIcon
    Private Sub Form1_FormClosed(ByVal sender As Object, _
                                 ByVal e As System.Windows.Forms.FormClosedEventArgs) _
                                 Handles Me.FormClosed

        mNotifyIcon.Dispose()
    End Sub


    Private Sub Form1_Load(ByVal sender As System.Object, _
                           ByVal e As System.EventArgs) _
                           Handles MyBase.Load
        ' inicializa las propiedades del FileSystemWatcher
        With FileSystemWatcher1
            ' no incluye directorios en el monitoreo
            .IncludeSubdirectories = False
            .EnableRaisingEvents = False
            ' Monitoreas todos los archivos del directorio
            .Filter = "*.*"
            ' filtros : Creacin, cambios en el archivo ( sin directorios )
            .NotifyFilter = NotifyFilters.CreationTime Or _
                            NotifyFilters.Size Or _
                            NotifyFilters.FileName

            'MsgBox(.NotifyFilter)
            chkActivar.Text = "Activar/Desactivar notificacin"
        End With

        ' agrega columnas ( path, el tipo de cambio y la fecha)
        With ListView1
            .View = View.Details
            .Columns.Add("Archivos ", 300)
            .Columns.Add("Tipo de modificacin", 120)
            .Columns.Add("fecha", 200)
        End With

        btnPath.Text = "Seleccionar directorio"

        ' establece el cono del form para NotifyIcon
        With mNotifyIcon
            .Icon = Me.Icon
        End With
    End Sub

    ' checkbox que activa o desactiva el FileSystemWatcher
    Private Sub chkActivar_CheckedChanged(ByVal sender As System.Object, _
                                          ByVal e As System.EventArgs) _
                                          Handles chkActivar.CheckedChanged
        cambiar_FSW(FileSystemWatcher1)
    End Sub

    ' cambia el path del FileSystemWatcher y lo habilita o deshabilita
    Sub cambiar_FSW(ByVal FSW As FileSystemWatcher)

        Try
            ' comprueba que el directorio existe
            If Directory.Exists(txtPath.Text) = True Then
                With FSW
                    .Path = txtPath.Text
                    ' activa o desactiva el  FileSystemWatcher
                    .EnableRaisingEvents = chkActivar.Checked
                End With
            End If
            ' error
        Catch sError As Exception
            MsgBox(sError.Message, MsgBoxStyle.Critical)
        End Try
    End Sub

    ' agrega los datos al listview ( el nombre del archivo 
    ' modificado, el tipo de cambio y la fecha)
    Sub Notificar_Cambio(ByVal Path As String, _
                         ByVal tipo As String)

        Dim oItem As New ListViewItem(Path)
        With oItem
            .SubItems.Add(tipo)
            .SubItems.Add(Date.Now.ToString)
            ListView1.Items.Add(oItem)
        End With

        With mNotifyIcon
            .ShowBalloonTip(5000, tipo, Path, ToolTipIcon.Info)
        End With

    End Sub

    'eventos para el control FileSystemWatcher
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''

    ' cambio en carpeta o archivos
    Private Sub FileSystemWatcher1_Changed(ByVal sender As System.Object, _
                                           ByVal e As System.IO.FileSystemEventArgs) _
                                           Handles FileSystemWatcher1.Changed
        Notificar_Cambio(e.Name, "Cambio")
    End Sub

    ' creacin 
    Private Sub FileSystemWatcher1_Created(ByVal sender As Object, _
                                           ByVal e As System.IO.FileSystemEventArgs) _
                                           Handles FileSystemWatcher1.Created
        Notificar_Cambio(e.Name, "Creacin")
    End Sub
    ' eliminacin de archivos o carpetas    
    Private Sub FileSystemWatcher1_Deleted(ByVal sender As Object, _
                                           ByVal e As System.IO.FileSystemEventArgs) _
                                           Handles FileSystemWatcher1.Deleted
        Notificar_Cambio(e.Name, "Eliminacin")
    End Sub

    ' evento de error
    Private Sub FileSystemWatcher1_Error(ByVal sender As Object, _
                                         ByVal e As System.IO.ErrorEventArgs) _
                                         Handles FileSystemWatcher1.Error
        MsgBox(e.GetException.ToString)
    End Sub

    ' eventos del componente NotifyIcon
    ' '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    Private Sub mNotifyIcon_Click(ByVal sender As Object, _
                                  ByVal e As System.EventArgs) _
                                  Handles mNotifyIcon.Click
        Me.Visible = True
        Me.WindowState = FormWindowState.Normal
    End Sub

    ' hace visible el NotifyIcon cuando se minimiza el formulario
    Private Sub Form1_Resize(ByVal sender As Object, _
                             ByVal e As System.EventArgs) _
                             Handles Me.Resize

        Select Case Me.WindowState
            Case FormWindowState.Minimized
                Me.Visible = False
                mNotifyIcon.Visible = True
                'Case FormWindowState.Normal
                '    mNotifyIcon.Visible = False
                '    Me.Visible = True
        End Select
    End Sub
End Class
